#include "ScnUtilities.h"
#include "freestyledash.h"
#include "scnfileop.h"
#include <direct.h>
#include "smc.h"
#include <string.h>

// stuff to handle overlapped io of message boxes
WCHAR result[1024];
XOVERLAPPED overlapped;
MESSAGEBOX_RESULT mbresult;
HANDLE hEvent;
int OverlapFunc = 0;

LPCWSTR btnOk[1] =
{
    L"OK"
};

LPCWSTR btnYesNo[2] =
{
    L"Yes", L"No"
};

LPCWSTR btnUsbHdd[2] =
{
    L"USB", L"HDD"
};

HRESULT CScnUtilities::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	GetChildById( L"RestartFreestyle", &m_Restart );
	GetChildById( L"CopyDVD", &m_CopyDVD );
	GetChildById( L"SystemStatus", &m_System );
	GetChildById( L"StorageStatus", &m_Storage );

	return S_OK;
}

XSWAPDISC_ERROR_TEXT swaptext;

HRESULT CScnUtilities::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (hObjPressed == m_Restart)
	{
		//_unlink(string(datapath + "content.xml").c_str());
		RestartFreestyle();
	}

	if (hObjPressed == m_CopyDVD)
	{
		bHandled = TRUE;

		if (!Mounted[DEVICE_CDROM0])
		{
 			Mounted[DEVICE_CDROM0] = Mount(DEVICE_CDROM0,"Dvd:");
		} else {
			Unmount("Dvd:");
 			Mounted[DEVICE_CDROM0] = Mount(DEVICE_CDROM0,"Dvd:");
		}

		if (!Mounted[DEVICE_CDROM0])
		{
			memset(&mbresult,0,sizeof(mbresult));
			memset(&overlapped,0,sizeof(overlapped));
			XShowMessageBoxUI(0,L"No disk in drive",L"Cannot copy DVD, there is no disk in the drive",1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
			return S_OK;
		}

		if (!FileExistsA("Dvd:\\default.xex") && !FileExistsA("Dvd:\\default.xbe"))
		{
			memset(&mbresult,0,sizeof(mbresult));
			memset(&overlapped,0,sizeof(overlapped));
			XShowMessageBoxUI(0,L"No default.xex on disc",L"Cannot copy DVD, there is no default.xex file on it, so it is probably not a xbox 360 game.",1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
			return S_OK;
		}

		OverlapFunc = 1;
		memset(&overlapped,0,sizeof(overlapped));
		XShowMessageBoxUI(0,L"Select destination drive",L"Please choose either to copy to external USB drive or internal HDD.",2,btnUsbHdd,0,XMB_NOICON,&mbresult,&overlapped);
		SetTimer(TM_OVERLAPPED,50);


		/*string dest = "USB:\\";
		memset(result,0,sizeof(result));
		memset(&overlapped,0,sizeof(overlapped));
		string message = sprintfa("Please enter the destination folder withing %sgames to copy the dvd contents to.",dest.c_str());
		HRESULT hr = XShowKeyboardUI(0,VKBD_DEFAULT|VKBD_HIGHLIGHT_TEXT,L"DEFAULT TITLE",L"Please enter destination folder",strtowstr(message).c_str(),result,1024,&overlapped);
		DebugMsg("XShowKeyboardUI - %08x",hr);*/

	} else if (hObjPressed == m_System)
	{
		bHandled = TRUE;
		ShowSystemStatus();
	} else if (hObjPressed == m_Storage)
	{
		bHandled = TRUE;
		ShowStorageStatus();
	}

	return S_OK;
} 

string DiskSpace(string drive)
{
	string file = drive + "\\";
	ULARGE_INTEGER FreeBytesAvailable;
	ULARGE_INTEGER TotalNumberOfBytes;
	ULARGE_INTEGER TotalNumberOfFreeBytes;

	GetDiskFreeSpaceEx(file.c_str(),&FreeBytesAvailable,&TotalNumberOfBytes,&TotalNumberOfFreeBytes);

	string result;
	string tempdrive = make_uppercaseA(drive);
	
	if (TotalNumberOfBytes.QuadPart > 1024*1024*1024)
	{
		result = sprintfaA("%s %0.1fGB / %0.1fGB Free\n",tempdrive.c_str(),(float)(TotalNumberOfBytes.QuadPart)/(1024.0f*1024.0f*1024.0f),(float)(TotalNumberOfFreeBytes.QuadPart)/(1024.0f*1024.0f*1024.0f));
	} else {
		result = sprintfaA("%s %0.1fMB / %0.1fMB Free\n",tempdrive.c_str(),(float)(TotalNumberOfBytes.QuadPart)/(1024.0f*1024.0f),(float)(TotalNumberOfFreeBytes.QuadPart)/(1024.0f*1024.0f));
	}

	return result;
}


void CScnUtilities::ShowStorageStatus()
{
	string storage = "Free Disk Space:\n\n";

	if (Mounted[DEVICE_USB0])
		storage.append(DiskSpace("Usb0:"));
	if (Mounted[DEVICE_USB1])
		storage.append(DiskSpace("Usb1:"));
	if (Mounted[DEVICE_USB2])
		storage.append(DiskSpace("Usb2:"));
	if (Mounted[DEVICE_HARDISK0_PART1])
		storage.append(DiskSpace("Hdd1:"));
	if (Mounted[DEVICE_HARDISK0_SYSPART])
		storage.append(DiskSpace("HddX:"));
	if (Mounted[DEVICE_MEMORY_UNIT0])
		storage.append(DiskSpace("Memunit0:"));
	if (Mounted[DEVICE_MEMORY_UNIT1])
		storage.append(DiskSpace("Memunit1:"));
	if (Mounted[DEVICE_MEMORY_ONBOARD])
		storage.append(DiskSpace("OnBoardMU:"));
	if (Mounted[DEVICE_NAND_FLASH])
		storage.append(DiskSpace("Flash:"));
	if (Mounted[DEVICE_CDROM0])
		storage.append(DiskSpace("Dvd:"));
	
	storage.append(DiskSpace("Game:"));

	memset(&overlapped,0,sizeof(overlapped));
	XShowMessageBoxUI(0,L"Storage Status",strtowstr(storage).c_str(),1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
}

void CScnUtilities::ShowSystemStatus()
{
	smc MySMC;
	string CPUString;
	string GPUString;
	string EDRAMString;
	string MBString;
	string temperature;
	//float * temperature;

	if (Cels == 1) {
		CPUString = sprintfaA("SYSTEM TEMPERATURE:\n\nCPU: %0.1f C\n", MySMC.GetTemperature(CPU,true));
		GPUString = sprintfaA("GPU: %0.1f C\n", MySMC.GetTemperature(GPU,true));
		EDRAMString = sprintfaA("EDRAM: %0.1f C\n", MySMC.GetTemperature(MEM,true));
		MBString = sprintfaA("MB: %0.1f C\n", MySMC.GetTemperature(BRD,true));
	} else {
		CPUString = sprintfaA("CPU: %0.1f F\n", MySMC.GetTemperature(CPU,false));
		GPUString = sprintfaA("GPU: %0.1f F\n", MySMC.GetTemperature(GPU,false));
		EDRAMString = sprintfaA("EDRAM: %0.1f F\n", MySMC.GetTemperature(MEM,false));
		MBString = sprintfaA("MB: %0.1f F\n", MySMC.GetTemperature(BRD,false));
	}
	//string IP = sprintfaA("\n%s\n\n",GetIp());
	string smcversion = sprintfaA("\nSYSTEM STATUS:\n\nSMC Version: %s\n", MySMC.GetSMCVersion());
	//string IPAddress = sprintfaA("IP Address: %s\n\n", GetIp());
	string tilt = sprintfaA("Xbox Orientation: %s\n", (MySMC.GetTiltState() == VERTICAL) ? "Vertical" : "Horizontal");
		

// Thanks goto Aaron for this
// Setting Names to AV Packs
const char* avpackname = MySMC.GetAVPackName();
string avpack;
if (avpackname)
	avpack = sprintfaA("AV Pack Type: %s\n", MySMC.GetAVPackName());
else
	avpack = sprintfaA("AV Pack Type: 0x%02x\n", MySMC.GetAVPack());



	//MATTIE: wrong info?
	//char* states[] = {"Open", "Opening", "Closed", "Closing", "Pushed"};
	char* states[] = {"Open", "-", "Closed", "Opening", "Closing"};
	string tray = sprintfaA("Tray Status: %s\n", states[MySMC.GetTrayState()]);

	temperature = CPUString + GPUString + EDRAMString + MBString + smcversion /*+ IPAddress*/ + tilt + avpack + tray;
	memset(&overlapped,0,sizeof(overlapped));
	XShowMessageBoxUI(0,L"System Status",strtowstr(temperature).c_str(),1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
}

string CScnUtilities::GetDefaultFolder()
{
	int i = 1;
	string Folder = sprintfaA("FSGame%d",i);
	while (FileExistsA(DestFolder + Folder))
	{
		i++;
		Folder = sprintfaA("FSGame%d",i);
	}

	return Folder;
}

WCHAR DefaultFolder[1024];

HRESULT CScnUtilities::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    // which timer is it?
    switch( pTimer->nId )
    {
        case TM_OVERLAPPED:
			{
				if (OverlapFunc == 1)
				{	
					if (XHasOverlappedIoCompleted(&overlapped))
					{
						if (overlapped.dwExtendedError == ERROR_SUCCESS)
						{
							string dest = "UNKNOWN";
							if (mbresult.dwButtonPressed == 0)
							{
								if (FileExistsA("Dvd:\\default.xex"))
								{
									dest = "usb0:\\games\\";
								} else {
									dest = "usb0:\\xbox1\\";
								}
							} else {
								if (FileExistsA("Dvd:\\default.xex"))
								{
									dest = "hdd1:\\games\\";
								} else {
									dest = "hdd1:\\xbox1\\";
								}
							}

							DestFolder = dest;

							memset(result,0,sizeof(result));
							memset(&overlapped,0,sizeof(overlapped));
							string message = sprintfaA("Please enter the destination folder within %s to copy the dvd contents to.",dest.c_str());
							string defaultfolder = GetDefaultFolder();
							DebugMsg("Using default folder %s",defaultfolder.c_str());
							wcscpy_s(DefaultFolder,1024,strtowstr(defaultfolder).c_str());
							HRESULT hr = XShowKeyboardUI(0,VKBD_DEFAULT|VKBD_HIGHLIGHT_TEXT,DefaultFolder,L"Please enter destination folder",strtowstr(message).c_str(),result,1024,&overlapped);
							if (ERROR_IO_PENDING == hr)
							{
								DebugMsg("XShowKeyboardUI OK - ERROR_IO_PENDING");
								OverlapFunc = 2;
							}
						} else {
							KillTimer(TM_OVERLAPPED);
						}
					}
				} else if (OverlapFunc == 2)
				{
					if (XHasOverlappedIoCompleted(&overlapped))
					{
					// destination entry completed
						KillTimer(TM_OVERLAPPED);
						OverlapFunc = 0;

						if (overlapped.dwExtendedError == ERROR_SUCCESS)
						{
							wstring res = result;
							CD_Dest = DestFolder + "\\" + wstrtostr(res);
							CD_Source = "dvd:\\";
							CD_Dest = str_replaceallA(CD_Dest,"\\\\","\\");
							CD_Action = CDA_COPYDVD;

							if (res.empty())
							{
								OverlapFunc = 4;
								SetTimer(TM_OVERLAPPED,50);
							} else if (FileExistsA(CD_Dest))
							{
								OverlapFunc = 3;
								SetTimer(TM_OVERLAPPED,50);
							} else {
								DebugMsg("Making dir %s",CD_Dest.c_str());
								_mkdir(CD_Dest.c_str());
								HXUIOBJ hScene = NULL;
								HRESULT hResult = CXuiScene::SceneCreate( L"fileop.xur", &hScene );
								hResult = CXuiScene::NavigateForward( hScene );
							}
						}
					}
				} else if (OverlapFunc == 3)
				{
					memset(&overlapped,0,sizeof(overlapped));
					string msg = sprintfaA("Destination folder '%s' already exists, please choose another",CD_Dest.c_str());
					HRESULT hr = XShowMessageBoxUI(0,L"Destination folder exists",strtowstr(msg).c_str(),1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
					if (ERROR_IO_PENDING == hr)
					{
						OverlapFunc = 0;
						KillTimer(TM_OVERLAPPED);
					}
				} else if (OverlapFunc == 4)
				{
					memset(&overlapped,0,sizeof(overlapped));
					HRESULT hr = XShowMessageBoxUI(0,L"No destination folder specified",L"No destination folder specified",1,btnOk,0,XMB_ERRORICON,&mbresult,&overlapped);
					if (ERROR_IO_PENDING == hr)
					{
						OverlapFunc = 0;
						KillTimer(TM_OVERLAPPED);
					}
				}
			}
			break;
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}
